//
//  PasswordHeader.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 17.02.23.
//

import UIKit

class PasswordHeader : UICollectionReusableView {
    
    let appLogo = UIImageView() // frame:CGRect(x:10, y:10, width:240, height:128)
    let appImage = UIImage(named: "LightBanking_font") // let appImage = UIImage(named: "Logo_LT_FullName")
    
    let loginText = UILabel()
    
    //let appPINTextLabel = UILabel()
    
    let d1 = UILabel()
    let d2 = UILabel()
    let d3 = UILabel()
    let d4 = UILabel()
    let d5 = UILabel()
    let d6 = UILabel()
    
    let passwordStackView = UIStackView()
    
    let passwordFirstDigitLabel = UILabel()
    let passwordSecondDigitLabel = UILabel()
    let passwordThirdDigitLabel = UILabel()
    let passwordFourthDigitLabel = UILabel()
    let passwordFifthDigitLabel = UILabel()
    let passwordSixhDigitLabel = UILabel()
    
    
    //let circle1 = UIView()
    let circle2 = UIView()
    let circle5 = UIView()
    
    
    let circleDigit1 = UIView()
    let circleDigit2 = UIView()
    let circleDigit3 = UIView()
    let circleDigit4 = UIView()
    let circleDigit5 = UIView()
    let circleDigit6 = UIView()
    
    let circle1View = UIView()
    
    //let circle3 = UIView()
    
    //let appLogo = UILabel()
    
    let passwordLabel = UILabel()
    
    override init(frame:CGRect) {
        super.init(frame: frame)
        
        // Activate Developer Mode in Variables.swift
        if !developerMode {
            passwordLabel.isHidden = false
            passwordStackView.isHidden = false
        }
        
        passwordFirstDigitLabel.text = "X"
        passwordSecondDigitLabel.text = "X"
        passwordThirdDigitLabel.text = "X"
        passwordFourthDigitLabel.text = "X"
        passwordFifthDigitLabel.text = "X"
        passwordSixhDigitLabel.text = "X"
        
        passwordFirstDigitLabel.font = UIFont.systemFont(ofSize: 10)
        passwordSecondDigitLabel.font = UIFont.systemFont(ofSize: 10)
        passwordThirdDigitLabel.font = UIFont.systemFont(ofSize: 10)
        passwordFourthDigitLabel.font = UIFont.systemFont(ofSize: 10)
        passwordFifthDigitLabel.font = UIFont.systemFont(ofSize: 10)
        passwordSixhDigitLabel.font = UIFont.systemFont(ofSize: 10)
        

        
        //passwordStackView.addConstraint(<#T##constraint: NSLayoutConstraint##NSLayoutConstraint#>)
        //Stack View
        passwordStackView.axis  = NSLayoutConstraint.Axis.horizontal
        passwordStackView.distribution  = UIStackView.Distribution.equalSpacing
        //passwordStackView.alignment = UIStackView.Alignment.center
        passwordStackView.spacing   = 10.0

        
        let size:CGFloat = 12.5
        circle2.bounds = CGRect(x: 0, y: 0, width: size, height: size)
        circle2.layer.cornerRadius = size / 2
        circle2.layer.borderWidth = 2
        circle2.layer.borderColor = UIColor.red.cgColor
        circle2.layer.backgroundColor = UIColor.red.cgColor
        
        circleDigit1.bounds = CGRect(x: 0, y: 0, width: size, height: size)
        circleDigit1.layer.cornerRadius = size / 2
        circleDigit1.layer.borderWidth = 1
        circleDigit1.layer.borderColor = UIColor.white.cgColor
        circleDigit1.layer.backgroundColor = UIColor.clear.cgColor
        
        circleDigit2.bounds = CGRect(x: 0, y: 0, width: size, height: size)
        circleDigit2.layer.cornerRadius = size / 2
        circleDigit2.layer.borderWidth = 1
        circleDigit2.layer.borderColor = UIColor.white.cgColor
        circleDigit2.layer.backgroundColor = UIColor.clear.cgColor
        
        circleDigit3.bounds = CGRect(x: 0, y: 0, width: size, height: size)
        circleDigit3.layer.cornerRadius = size / 2
        circleDigit3.layer.borderWidth = 1
        circleDigit3.layer.borderColor = UIColor.white.cgColor
        circleDigit3.layer.backgroundColor = UIColor.clear.cgColor
        
        circleDigit4.bounds = CGRect(x: 0, y: 0, width: size, height: size)
        circleDigit4.layer.cornerRadius = size / 2
        circleDigit4.layer.borderWidth = 1
        circleDigit4.layer.borderColor = UIColor.white.cgColor
        circleDigit4.layer.backgroundColor = UIColor.clear.cgColor
        
        circleDigit5.bounds = CGRect(x: 0, y: 0, width: size, height: size)
        circleDigit5.layer.cornerRadius = size / 2
        circleDigit5.layer.borderWidth = 1
        circleDigit5.layer.borderColor = UIColor.white.cgColor
        circleDigit5.layer.backgroundColor = UIColor.clear.cgColor
        
        circleDigit6.bounds = CGRect(x: 0, y: 0, width: size, height: size)
        circleDigit6.layer.cornerRadius = size / 2
        circleDigit6.layer.borderWidth = 1
        circleDigit6.layer.borderColor = UIColor.white.cgColor
        circleDigit6.layer.backgroundColor = UIColor.clear.cgColor
        
        let size2:CGFloat = 25.0
        circle5.bounds = CGRect(x: 0, y: 0, width: size2, height: size2)
        circle5.layer.cornerRadius = size2 / 2
        circle5.layer.borderWidth = 2
        circle5.layer.borderColor = UIColor.black.cgColor
        circle5.layer.backgroundColor = UIColor.yellow.cgColor
        

        passwordStackView.addArrangedSubview(passwordFirstDigitLabel)
        passwordStackView.addArrangedSubview(passwordSecondDigitLabel)
        passwordStackView.addArrangedSubview(passwordThirdDigitLabel)
        passwordStackView.addArrangedSubview(passwordFourthDigitLabel)
        passwordStackView.addArrangedSubview(passwordFifthDigitLabel)
        passwordStackView.addArrangedSubview(passwordSixhDigitLabel)
        

        
        addSubview(circleDigit1)
        d1.insertSubview(circleDigit1, aboveSubview: d1)
        d1.text = ""
        d1.textAlignment = .center
        addSubview(d1)
        d1.centerInSuperviewPINFieldDigi1()
        
        addSubview(circleDigit2)
        d2.insertSubview(circleDigit2, aboveSubview: d2)
        d2.text = ""
        d2.textAlignment = .center
        addSubview(d2)
        d2.centerInSuperviewPINFieldDigi2()
        
        addSubview(circleDigit3)
        d3.insertSubview(circleDigit3, aboveSubview: d3)
        d3.text = ""
        d3.textAlignment = .center
        addSubview(d3)
        d3.centerInSuperviewPINFieldDigi3()
        
        addSubview(circleDigit4)
        d4.insertSubview(circleDigit4, aboveSubview: d4)
        d4.text = ""
        d4.textAlignment = .center
        addSubview(d4)
        d4.centerInSuperviewPINFieldDigi4()
        
        addSubview(circleDigit5)
        d5.insertSubview(circleDigit5, aboveSubview: d5)
        d5.text = ""
        d5.textAlignment = .center
        addSubview(d5)
        d5.centerInSuperviewPINFieldDigi5()
        
        addSubview(circleDigit6)
        d6.insertSubview(circleDigit6, aboveSubview: d6)
        d6.text = ""
        d6.textAlignment = .center
        addSubview(d6)
        d6.centerInSuperviewPINFieldDigi6()
        

        circle1View.bounds = CGRect(x: 0, y: 0, width: size2, height: size2)
        circle1View.layer.cornerRadius = size2 / 2
        circle1View.layer.borderWidth = 2
        circle1View.layer.borderColor = UIColor.green.cgColor
        circle1View.layer.backgroundColor = UIColor.green.cgColor

        
        
        //addSubview(passwordStackView)
        passwordStackView.centerInSuperviewDeveloperModePasswordStackView()
        

        
        passwordLabel.text = "123456"
        passwordLabel.font = UIFont.systemFont(ofSize: 16)
        passwordLabel.textAlignment = .center
        passwordLabel.centerInSuperviewDeveloperModePINLabel()
        

         
        loginText.text = "Sign in with App PIN" // Melde Dich in der App an
        loginText.textColor = .white
        loginText.font = UIFont.systemFont(ofSize: 17, weight: .semibold)
        addSubview(loginText)
        loginText.centerInSuperviewLoginText()
        
        appLogo.image = appImage
        appLogo.contentMode = .scaleAspectFit
        appLogo.translatesAutoresizingMaskIntoConstraints = false
        let heightConstraint = NSLayoutConstraint(item: appLogo, attribute: .height, relatedBy: .equal, toItem: nil, attribute: .notAnAttribute, multiplier: 1.0, constant: 240)
        let widthConstraint = NSLayoutConstraint(item: appLogo, attribute: .width, relatedBy: .equal, toItem: nil, attribute: .notAnAttribute, multiplier: 1.0, constant: 128)
        appLogo.addConstraints([heightConstraint, widthConstraint])
        
        addSubview(appLogo)
        appLogo.centerInSuperviewAppLogo()

        
    }
    
    required init?(coder aDecoder:NSCoder) {
        fatalError()
    }
}

